--------------------------------------------------------------------
--            SymCACP Script Module Find End Chaos
-- Rule H1D8 waves some times colapses to chaos 
-- Symmetrical CA Control Panel   symCACPscript-1
-- End is determined when the population is very small - not chaos
-- or when the maximum length diaganol pair of lines of the same state
-- can reasonable be classed as part of chaos.
-- This length will be deteremed elswhere.
--------------------------------------------------------------------
--  P. Rendell  19/08/2020
--------------------------------------------------------------------

--
-- output 
-- RULE, WD, HT, SEED, GEO, GEN, RUNLEN


------------------------------------------------------------

local scriptType = "script2-findEnd"
local m={}			-- class table
m.cnt = 0
local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local gr = require("buildUni") 
local gs = require("search-chaos") 
m.colonList = {['RULES'] = {"r","R"}, ['SEEDS'] = {"s","R"}, ['GEO'] = {'g',""}}
m.equalList = {['WIDTH0'] = {"d","R"}, ['WIDTH1'] = {"d",""}, ['WIDTHS'] = {"d",""},
               ['LOGFILE'] = {'t',""}, ['RESULTS_OLD'] = {'t',""}, ['RESULTS_NEW'] = {'t',"R"},
               ['STEP1'] = {"d","R"}, ['MAX_OSC'] = {"d","R"}, ['MIN_OSC'] = {"d","R"},
               ['MAX_GEN'] = {'d',"R"}, ['CASTLE'] = {'l',"R"},
               ['VERIFY'] = {'l',"R"},['CHECK_MAX_GEN'] = {'l',"R"},['SAVE_OTHERS'] = {'l',"R"} }

------------------------------------------------------------------------------------------------


--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
   logFile:write("search-chaos:Got Log File\n")
   gs.init(logFile)
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      comProcs.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = {"R"}
   end
   return true
end



--==============================================================================

local function doFINDpopRes(outFile, rule, geo, wv, hv, seed, gen, oscPeriod, pop, res)
   outFile:write(string.format("%s,%s,%s,%s,%s,%s,%s,%i,%s\n",
                               rule, geo:sub(1,2), wv, hv, seed, gen, oscPeriod, pop, res))
   outFile:flush()                                
end
--------------------------------------------------------------------------------
function saveResults(typeOR)
   --   key = rule..':'..geo:sub(1,2)..':'..tostring(hv)..':'..tostring(wv)..':'..seed
   --   m.linesDone[key] = {gen, period, type}
   m.cnt = m.cnt + 1
   logFile:write("saveResults call "..m.cnt..'\n')
   local a = false; for k in pairs(m.linesDone) do a = true; break end  -- test that m.linesDone is not empty
   if m.outFile and a and ((scriptFileData.SAVE_OTHER) or (typeOR == "override") ) then
      local keyPart
      for key in pairs(m.linesDone) do
         keyPart = {}
         for word in string.gmatch(key, "[^:]+") do
            keyPart[#keyPart + 1] = word
         end
         if ((#keyPart == 5) and (#m.linesDone[key] == 4)) then
              doFINDpopRes(m.outFile, keyPart[1], keyPart[2], keyPart[3], keyPart[4], keyPart[5], m.linesDone[key][1], m.linesDone[key][2], m.linesDone[key][3], m.linesDone[key][4])
              m.linesDone[key] = nil
         else
            logFile:write("** saveResults: either key "..key.." does not have 5 parts or linesDone[key] "..#m.linesDone[key].." does not have 4 parts\n")
         end
      end
      m.outFile:close(); m.outFile = nil
   end
end

--------------------------------------------------------------------------------

function openOutFile()
   local res = false
   local words = {}
   local key
   local inFile
   local test = true
   m.linesDone = {}
   logFile:write(' openOutFile\n')
   if scriptFileData then
      inFile = io.open ( scriptFileData.RESULTS_NEW , "r")
      if inFile then
         m.outFile = io.open ( scriptFileData.RESULTS_OLD , "w")
         if m.outFile then
            local line = inFile:read("*l")
            while line do
               m.outFile:write(line..'\n')
               line = inFile:read("*l")
            end
            inFile:close(); inFile = nil
            m.outFile:close(); m.outFile = nil
            m.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
            inFile = io.open ( scriptFileData.RESULTS_OLD , "r")
            if m.outFile and inFile then
               local line = inFile:read("*l")
               while line do
                  if (line:sub(1,4) ~= "RULE") then
                     words = split(line)
                     if #words == 9 then
                        key = words[1]..':'..words[2]..':'..words[3]..':'..words[4]..':'..words[5]
                        if  (m.linesDone[key]) and (words[9] == 'maxEx') then
                           if (m.linesDone[key][4] ~= 'end') and 
                                ( 
                                  (tonumber(words[6]) > tonumber(m.linesDone[key][1])) or
                                  (tonumber(words[7]) < tonumber(m.linesDone[key][2])) or 			-- for maxEx period is negative
                                  (tonumber(words[7]) > 0 )  			-- for maxEx period is negative
                                ) 
                            then
                               logFile:write('m.linesDone changed '..m.linesDone[key][1]..'->'..words[6]..' \n')
                               m.linesDone[key] = {words[6],words[7],words[8],words[9]}
                           end
                        else
                           m.linesDone[key] = {words[6],words[7],words[8],words[9]}	-- gen, period, pop, type
                        end
                     else
                        logFile:write('openOutFile line '..line..' not 9 words\n')
                     end                     
                  end
                  line = inFile:read("*l")
               end 
               logFile:write('m.linesDone collected '..#m.linesDone..'\n')
               res = true
            else
               logFile:write("openOutFile (2nd) files not open infile:"..comProcs.bool2txt(inFile).." outfile:"..comProcs.bool2txt(m.outFile).."\n")
               res = false
               m.outFile:close(); m.outFile = nil
            end
            inFile:close(); inFile = nil
         else
            logFile:write("openOutFile (1st) files not open infile:"..comProcs.bool2txt(inFile).." outfile:"..comProcs.bool2txt(outFile).."\n")
            comProcs.report.collect('no RESULTS_OLD',false)
            inFile:close(); inFile = nil
            res = false
         end         
      else
         logFile:write("openOutFile no old file to copy\n")
         m.outFile = io.open(scriptFileData.RESULTS_NEW, "w")
         res = m.outFile ~= nil
      end
   else
      logFile:write("openOutFile no script file data\n")
      res = false
   end
   if (res) then
      m.outFile:write("RULE,GEO,WD,HT,SEED,GEN,PERIOD,POP,TYPE\n")
   end
   return res
end

------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

function m.run(segmentNo)
   logFile:write('\ndoFINDEND-n\n')
   local test =true
   local logDiverted
   g.show('Find End Started')
   if scriptFileData then
      if scriptFileData.LOGFILE then
         logDiverted = divertLog(scriptFileData.LOGFILE)
      end
      if (scriptFileData.CASTLE) then
          gr.GobalSwitch("CASTLE",true)
      end
      comProcs.LogScript(segmentNo)
--      if ( openOutFile(m,scriptFileData) ) then
      if ( openOutFile() ) then
         gs.init(logFile)
         logFile:write('\ndoFINDEND-Chaos\n')
         local OldOnly = true
         m.GetSamples(OldOnly)
         OldOnly = false
         m.GetSamples(OldOnly)
      end
   else
     comProcs.showTextOV('No Script file Loaded')
   end
   g.show('Finished')
   if (scriptFileData.SAVE_OTHERS == 'TRUE') or (res == 'killed') then
      saveResults("override")
   else
      if (m.outFile ~= nil) then
         m.outFile:close();
         m.outFile = nil
      else
         comProcs.showTextOV('\nProblems copying old data\n')
      end      
   end
end
------------------------------------------------------------

function m.GetSamples(OldOnly)
--------------------------------------------------------------------------
   local rule, seed, geo, hv, wv
   local verify = scriptFileData.VERIFY
   local check_max_gen = scriptFileData.CHECK_MAX_GEN
   logFile:write("verify "..comProcs.bool2txt(verify).."\n")
   function runOne(wv,hv,geo)
      local res
      local step1 =  scriptFileData.STEP1
      local doIt = true
      local key = rule..':'..geo:sub(1,2)..':'..tostring(hv)..':'..tostring(wv)..':'..seed
      local endstr = 'none'
      local maxGen = scriptFileData.MAX_GEN
      local maxOsc = scriptFileData.MAX_OSC
      local minOsc = scriptFileData.MIN_OSC
      if (m.linesDone[key]) then
         doIt = (verify and (m.linesDone[key][4] == 'end') )
             or (check_max_gen and (m.linesDone[key][4] == 'maxEx')
                               and ( (tonumber(m.linesDone[key][1]) < maxGen)
                                     or (-tonumber(m.linesDone[key][2]) < maxOsc)
                                   )
                )
             or (m.linesDone[key][4] == 'killed')
         if(not doIt and OldOnly) then
            doFINDpopRes(m.outFile, rule, geo, wv, hv, seed, m.linesDone[key][1], m.linesDone[key][2], m.linesDone[key][3],m.linesDone[key][4])
         else
            logFile:write("dataOK "..m.linesDone[key][1]..","..m.linesDone[key][2]..","..m.linesDone[key][3]..","..m.linesDone[key][4].."\n")
            doFINDpopRes(logFile, rule, geo, wv, hv, seed, m.linesDone[key][1], m.linesDone[key][2], m.linesDone[key][3], m.linesDone[key][4])
            if (verify) and (m.linesDone[key][4] == 'end') then
               maxGen = tonumber(m.linesDone[key][1])+100
               maxOsc = tonumber(m.linesDone[key][2])+10
               minOsc = 1
            end
            step1 = math.max( 0,math.min( tonumber(m.linesDone[key][1]),maxGen)*0.6  )
            logFile:write("Step1 ",step1,"; end type "..m.linesDone[key][4]..' doIt '..comProcs.bool2txt(doIt)..' verify '..comProcs.bool2txt(verify)..'\n')
         end
      end
      if (not OldOnly) then
         if (doIt) then
            if (m.linesDone[key]) and (check_max_gen) and (tonumber(m.linesDone[key][2]) > 0) and (tonumber(m.linesDone[key][1]) > maxGen) then
               maxGen = tonumber(m.linesDone[key][1])
            end
            gr.doBuild(' SymCACP FindEnd ', wv, hv, seed, geo, rule)  -- w, h, seed, rule, format
            res = gs.doFindEnd(seed, maxGen, step1, minOsc, maxOsc)
            if (res ~= 'killed') or (not m.linesDone[key]) then
               if (res ~= 'killed') then
                  g.show(res..' seed '..seed..' gen '..tonumber(g.getgen()))
               end
               if ( res == "maxEx") then 
                  doFINDpopRes(m.outFile, rule, geo, wv, hv, seed, tonumber(g.getgen()), -maxOsc, gs.pop,res)
               else
                  doFINDpopRes(m.outFile, rule, geo, wv, hv, seed, tonumber(g.getgen()), gs.oscPeriod, gs.pop,res)
               end
               m.linesDone[key] = nill
            end
         end
      end
      return res
   end
   
   local res = ''
   for wv = scriptFileData.WIDTH0,scriptFileData.WIDTH1,scriptFileData.WIDTHS do
      for ir = 1,#scriptFileData.RULES do
         rule = scriptFileData.RULES[ir]
         g.new('SymCACP Script '..scriptFileData.RESULTS_NEW..' '..rule..' ')
         for geoI,geo in pairs(scriptFileData.GEO) do
            g.show("width "..scriptFileData.WIDTH0..","..scriptFileData.WIDTH1..","..scriptFileData.WIDTHS)
            for is = 1,#scriptFileData.SEEDS do
               seed = scriptFileData.SEEDS[is]
               res = runOne(wv,wv,geo)
               if res == 'killed' then break end
            end
            m.outFile:flush()
            if res == 'killed' then break end
         end
         if res == 'killed' then break end
      end
      if res == 'killed' then break end
   end
   if ((not OldOnly) and logDiverted) then
      logFile:flush()
      reDivertLog()
   end
end
return m
------------------------------------------------------------
